#include "metals.inc"
#include "colors.inc"
#declare E_R00=0
camera {location <0,40,120> look_at <0,0,0> angle 5}
//background {rgb 1}


   light_source {<250,300,500>
    color rgb 1.25
    area_light <0,50,0>, <50,0,0>,3, 3
    adaptive 1
    spotlight
    point_at 0
    radius 50
    falloff 75
   }
   light_source {<-250,0,0>
    color rgb <0,0,.5>
    //area_light <0,1000,0>, <1000,0,0>,3, 3
    //adaptive 1
    spotlight
    point_at 0
    radius 50
    falloff 75
   }



#declare EYE_ROTATE = <0,0,0>
//normal skin
#declare SkinTexture =
texture {
  pigment { color rgb <0.9,0.65,0.43> }
  finish { diffuse 0.6 phong 0.15 phong_size 20 }
  }
/*  
texture{
pigment {
rgb (Flesh+Gold+Salmon+Wheat+Bronze2+Salmon+Flesh+NewTan)/8
}
normal {
bumps .2 
scale.005 
bump_size .25
}
finish{
diffuse .4
ambient .1
diffuse 1
}
}*/

//slightly blushed skin
#declare SkinTexture2 =
texture{
pigment {
rgb (Flesh+Salmon+DustyRose+Flesh)/4*1.25*.15
}
normal {
bumps .2 
scale.005
bump_size .06125
}
finish{
diffuse .4
ambient .1
diffuse 1
}
}
//Texture for the lips
#declare LipTexture =
texture{
pigment {
rgb (IndianRed+Scarlet+DustyRose+Salmon+Flesh+Red)/6
}
normal {
bumps .2 
scale.01 
bump_size .06125
}
finish{
diffuse .1
ambient 0
diffuse 1
phong 1.5
phong_size 20
}
}
//"White" of the eyeball
#declare EyeBallTexture =
texture{
pigment{
color rgb <1,.97,.97>
}
finish{
diffuse .9
specular .9
roughness .001
ambient .1
reflection 0
}
}
//"colored" part of the eye
#declare IrisTexture =
texture{ 
//pigment{color rgb <50,.3,.1>}
pigment{
color rgb <.1,.2,.15>*3
}
finish{
diffuse 1
specular .9
roughness .001
ambient .1
//reflection .3
}
}
//Base for the hair
#declare HairTexture =
texture{
pigment{ bozo
color_map {
[0 rgb DarkBrown]
[.5 rgb DarkBrown*1.5]
[1 rgb DarkBrown*.5]
}
}
scale <1,10,5>
scale .25
}
texture{
pigment{ radial frequency 400 triangle_wave
color_map {
[0 rgb DarkBrown transmit 1]
[1 rgb DarkBrown*.5]
}
turbulence .5
}
scale <1,10,5>
scale .25
scale .125
}


//pigment{color rgb <0,.85,.7>}
#declare FaceSize = .65
#declare FaceSizeFloat = 3
#declare FaceThreshold = FaceSizeFloat*pow((1-pow(FaceSize,2)),2)

#declare FemaleFace=
blob{ threshold FaceThreshold

//part 01 Basic Skull
   cylinder{<0,0,.5><0,0,-.5>,1,FaceSizeFloat
      scale <1.5/FaceSize,1.2/FaceSize,.85/FaceSize>
      translate y*.45
      }
   cylinder{<.9,0,0><-.9,0,0>,1,FaceSizeFloat
      scale <.7/FaceSize,1.3/FaceSize,.8/FaceSize>
      translate y*.3}
   sphere{0,1,FaceSizeFloat
      scale <1.2/FaceSize,1.1/FaceSize,1.1/FaceSize>
      translate <.8,-.3,0>}

//part 02 area behind eyes
   cylinder{<0,0,.49><0,0,-.49>,1,FaceSizeFloat
      scale <.55/FaceSize,.75/FaceSize,.67/FaceSize>
      rotate z*30 translate <-.75,-.3,0>
      }

//part 03 upper cheeks and jaw
   cylinder{<0,0,.49><0,0,-.49>,1.5,FaceSizeFloat*.065
      scale 1
      scale <.75/FaceSize,.5/FaceSize,.68/FaceSize>
      translate <-.9,-.95,0> texture {SkinTexture2}}
   cylinder{<0,0,.48><0,0,-.48>,1.5,FaceSizeFloat*.065
      scale 1
      scale <.5/FaceSize,.5/FaceSize,.64/FaceSize>
      translate <-.5,-1.45,0> texture {SkinTexture2}}
   sphere{0,1,FaceSizeFloat
      scale <.4/FaceSize,.5/FaceSize,.61/FaceSize>
      translate <-1.2,-1.6,0>}

//part 04 Lips
               sphere {0,1,FaceSizeFloat
               scale < 0.3, 0.10607, 0.475 >
               rotate < 0, 0, 45 >
               translate < -1.7, -1.675, 0 >
               scale <1,1,1.1>
               texture {LipTexture}}
               
               sphere {0,1,FaceSizeFloat
               scale < 0.3, 0.10607, 0.34358 >
               rotate < 15.42, 0, -26.565 >
               translate < -1.7, -1.575, 0.125 >
               scale <1,1,1.1>
               texture {LipTexture}}

               sphere {0,1,FaceSizeFloat
               scale < -0.3, -0.10607, -0.34358 >
               rotate < 18.281, 0, 153.43 >
               translate < -1.7, -1.575, -0.125 >
               scale <1,1,1.1>
               texture {LipTexture}}
               
         sphere {0,1,FaceSizeFloat
         scale < 0.1, 0.075, 0.212 >
         rotate < 24.876, 0, 45 >
         translate < -1.65, -1.65, -0.3 >
         texture {LipTexture}}
         
         sphere {0,1,FaceSizeFloat
         scale < 0.1, 0.075, 0.212 >
         rotate < -24.876, 0, 45 >
         translate < -1.65, -1.65, 0.3 >
         texture {LipTexture}}
         
         //part 04b lipchannel
         sphere {0,1,-.65
         scale < 0.22626, 0.27932, 0.075 >
         rotate < 0, 0, -8.213 >
         translate < -1.95, -1.3, 0 >
         texture {SkinTexture}}
        
         sphere {0,1,-.65
         scale < 0.237, 0.25458, 0.075 >
         rotate < 0, 0, -8.213 >
         translate < -1.95, -1.2, 0 >
         texture {SkinTexture}}
         
         sphere {0,1,-.65
         scale < 0.12729, 0.15203, 0.075 >
         rotate < 0, 0, -8.213 >
         translate < -2.025, -1.4, 0 >
         texture {SkinTexture}}


//part05 Chin
   cylinder{<1,0,0><0,0,0>,1,FaceSizeFloat
      scale <.5/FaceSize,.4/FaceSize,.48/FaceSize>
      rotate y*10
      rotate z*17
      translate <-1.19,-1.97,-.15>}
   cylinder{<1,0,0><0,0,0>,1,FaceSizeFloat
      scale <.5/FaceSize,.4/FaceSize,.48/FaceSize>
      rotate y*-10
      rotate z*17
      translate <-1.19,-1.97,.15>}

//part06 Middle Cheeks and sides of lips
   cylinder{<0,0,0><0,1,0>,1,FaceSizeFloat
      scale <.9/FaceSize,.5/FaceSize,.75/FaceSize>
      rotate <-7,0,-10>
      translate<-.6,-1.6,-.31> }
   cylinder{<0,0,0><0,1,0>,1,FaceSizeFloat
      scale <.9/FaceSize,.5/FaceSize,.75/FaceSize>
      rotate <7,0,-10>
      translate<-.6,-1.6,.31> }

//part071 Bridge of nose
   cylinder{<0,0,0><0,.85,0>,1,FaceSizeFloat
      scale <.45/FaceSize,.3/FaceSize,.165/FaceSize>
      rotate z*-32
      translate<-1.7,-.93,0>}
//part072 sides of nose
   sphere{0,1,FaceSizeFloat
      scale <.25/FaceSize,.13/FaceSize,.1/FaceSize>*.72
      rotate <0,27,-19>
      translate<-1.82,-.92,-.25>}
   sphere{0,1,FaceSizeFloat
      scale <.25/FaceSize,.13/FaceSize,.1/FaceSize>*.72
      rotate <0,-27,-19>
      translate<-1.82,-.92,.25>}
//part073 tip of nose
   sphere{0,1.25,FaceSizeFloat*.065
      scale <.26/FaceSize,.15/FaceSize,.25/FaceSize>
      rotate <0,0,-2>
      translate<-1.9,-.97,0>}
//part074 above Upper lip
   sphere{0,1,FaceSizeFloat
      scale <.2/FaceSize,.25/FaceSize,.3/FaceSize>
      rotate z*-20
      translate<-1.55,-1.3,0>}
      
     


//part08b Eye "Holes"
   sphere{0,1,-2
      scale <.4/FaceSize,.27/FaceSize,.45/FaceSize>
      rotate <5,-18,0>
      translate<-1.5,-.3,-.76>
         texture {SkinTexture}}
   sphere{0,1,-2
      scale <.4/FaceSize,.27/FaceSize,.45/FaceSize>
      rotate <-5,18,0>
      translate<-1.5,-.3,.76>
         texture {SkinTexture}}

//part09
   cylinder{<0,0,0><0,-1.8,0>,1,FaceSizeFloat
      scale <.9/FaceSize,1,.8/FaceSize>
      rotate z*7
      translate <.3,-1.5,0>}
sturm
texture {SkinTexture}}

#declare LeftEye=
union{
   difference{
      blob{
         sphere{0,1,FaceSizeFloat
            scale <.4/FaceSize,.39/FaceSize,.47/FaceSize>*.85
               texture {SkinTexture}}
         sphere{0,1,FaceSizeFloat
            scale <.7/FaceSize,.18/FaceSize,.36/FaceSize>*.85
            translate z*-.04
               texture {SkinTexture}}
      }
      sphere{0,1
         scale <4,.14,.4>*.85
         rotate z*4
         rotate x*-1
         rotate y*5
         translate z*-.04
            texture {SkinTexture}}
   }
   sphere{0,1
      scale <.4,.39,.4>*.845
         texture {EyeBallTexture}}
   sphere{0,1
      scale .19
      translate x*-.2
      rotate <0,5,0>
      rotate <EYE_ROTATE.x,EYE_ROTATE.y,0>
         texture {IrisTexture}}
   sphere{0,1
      scale .1
      translate x*-.3
      //rotate <0,5,0>
      rotate <EYE_ROTATE.x,EYE_ROTATE.y,0>
         texture {EyeBallTexture} pigment{ color rgb <0,0,.0>}}

      rotate <4,-15,0>
      translate<-1.21,-.33,-.54>
}

#declare RightEye=
union{
   difference{
      blob{
         sphere{0,1,FaceSizeFloat
            scale <.4/FaceSize,.39/FaceSize,.47/FaceSize>*.85
               texture {SkinTexture}}
         sphere{0,1,FaceSizeFloat
            scale <.7/FaceSize,.18/FaceSize,.36/FaceSize>*.85
            translate z*.04
               texture {SkinTexture}}
      }
      sphere{0,1
         scale <4,.14,.4>*.85
         rotate z*4
         rotate x*1
         rotate y*-5
         translate z*.04
            texture {SkinTexture}}
   }
   sphere{0,1
      scale <.4,.39,.4>*.845
         texture {EyeBallTexture}}
   sphere{0,1
      scale .19
      translate x*-.2
      //rotate <0,-5,0>
      rotate <EYE_ROTATE.x,EYE_ROTATE.y,0>
      texture {IrisTexture}
         }
   sphere{0,1
      pigment{rgb 0}
      scale .1
      translate x*-.3
      rotate <EYE_ROTATE.x,EYE_ROTATE.y,0>
      rotate EYE_ROTATE
         }

      rotate <-4,15,0>
      translate<-1.21,-.33,.54>
}


#declare FemaleHead=
union{
   object{FemaleFace}

   object{LeftEye}
   object{RightEye}
   
/*
   sphere{0,1
      scale <.4,.37,.44>*.85
      rotate <-3,15,0>
      translate<-1.21,-.33,.58>
      texture {SkinTexture} pigment{color rgb <1,.85,.7>*.8}}
*/
   blob{
   sphere{0,1,FaceSizeFloat
      scale <.2/FaceSize,.65/FaceSize,.4/FaceSize>
      rotate <-14,-60,-5>
      translate<0.2,-.54,-1.5>}
   sphere{0,1,-4
      scale <.5/FaceSize,.62/FaceSize,.35/FaceSize>*.6
      rotate <-14,-60,-8>
      translate<0.1,-.45,-1.7>}

   sphere{0,1,FaceSizeFloat
      scale <.2/FaceSize,.65/FaceSize,.4/FaceSize>
      rotate <14,60,-5>
      translate<0.2,-.54,1.5>}
   sphere{0,1,-4
      scale <.5/FaceSize,.62/FaceSize,.35/FaceSize>*.6
      rotate <14,60,-8>
      translate<0.1,-.45,1.7>}

   cylinder{<0,0,1><0,0,-1>,1,FaceSizeFloat
      scale <.2/FaceSize,.25/FaceSize,.65/FaceSize>
      translate<0,-.54,0>}
   scale<.95,.95,1>
   texture {SkinTexture}}
   
   
}


#declare FemaleHair=
blob{ threshold FaceThreshold
   #declare HairCount=4;
   #while (HairCount>0)
      sphere{0,1.125,FaceSizeFloat*.75
         scale <2.2/FaceSize,1.3/FaceSize,1.5/FaceSize>*(1+.05*HairCount)
         translate y*-1.2*HairCount}
   #declare HairCount=HairCount-1;
   #end
   cylinder{<0,0,0><0,-2,0>,1,-6
      scale <2.2/FaceSize,2,1.5/FaceSize>
      translate <-1,-2.7,.1>}
   cylinder{<0,0,0><0,-2,0>,1,-1
      scale <2.2/FaceSize,2,.7/FaceSize>
      translate <-1,-1.8,.5>}
   cylinder{<0,0,0><0,-2,0>,1,-6
      scale <2.5/FaceSize,3,1.5/FaceSize>
      translate <-2,-4,0>}
   cylinder{<0,0,0><0,-2,0>,1,-6
      scale <2.5/FaceSize,3,1.8/FaceSize>
      translate <-1.8,-6,0>}
rotate z*5
translate <-.2,2.2,0>
scale<.9,1,1>
texture {HairTexture}
}

#declare Glasses =
union {
           
               torus { 0.35, 0.025
               scale < 1.5*.5, 1.5, 1.5 >
               rotate < 0, 0, -90 >
               translate < -2.1, -0.35, 0.7 >
            }

              /* disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0
               scale < 0.55*.5, 1, 0.55 >
               rotate < 0, 0, 90 >
               translate < -2.1, -0.35, 0.7 >
               pigment {rgbft <0,0,0,1,.25>}
               finish {ambient .01 diffuse 1 phong 1 reflection .25}
            }*/
object {
object{quadric{<1,0,1>,<0,0,0>,<0,-1,0>,0}clipped_by{plane{<0,1,0>,1}}}
scale<.55*.5,.175,.55>
rotate<0,0,-90>
translate <-2.275,-0.35,0.7> 
pigment {rgbft <0,0,0,1,.25>}                       
finish {ambient .01 diffuse 1 phong 1 reflection .25}
}
               torus { 0.35, 0.025
               scale < 1.5*.5, 1.5, 1.5 >
               rotate < 0, 0, -90 >
               translate < -2.1, -0.35, -0.7 >
            }
/*               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 
               scale < 0.55*.5, 1.5, 0.55 >
               rotate < 0, 0, 90 >
               translate < -2.1, -0.35, -0.7 >
               pigment {rgbft <0,0,0,1,.25>}                       
               finish {ambient .01 diffuse 1 phong 1 reflection .25}
            }*/
object {
object{quadric{<1,0,1>,<0,0,0>,<0,-1,0>,0}clipped_by{plane{<0,1,0>,1}}}
scale<.55*.5,.175,.55>
rotate<0,0,-90>
translate <-2.275,-0.35,-0.7> 
pigment {rgbft <0,0,0,1,.25>}                       
finish {ambient .01 diffuse 1 phong 1 reflection .25}
}
 
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1
         scale < 0.015, 0.125, 0.055 >
         rotate < 90, 0, 0 >
         translate < -2.1, -0.3, 1.15 >
         }
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1     
         scale < 0.015, 1.925, 0.055 >
         rotate < 90, 90, 0 >
         translate < -2.1, -0.3, 1.225 >
         }
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1
         scale < 0.015, 0.125, 0.055 >
         rotate < 90, 0, 0 >
         translate < -2.1, -0.3, 1.15 >
         scale <1,1,-1>
         }
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1     
         scale < 0.015, 1.925, 0.055 >
         rotate < 90, 90, 0 >
         translate < -2.1, -0.3, 1.225 >
         scale <1,1,-1>
         }
   
         difference
         {
            
               torus { 0.375, 0.025
               scale < 1, 1, 0.625 >
               rotate < 0, 0, -90 >
               translate < -2.1, -0.55, 9.7477e-40 >
            }
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 
               scale < 20, 1, 20 >
               translate < 0, -0.45, 0 >
            }
         }
        pigment {rgb .1}
        scale <1,1,1.1>
        translate <.1,0,0>
        }

#declare FemaleFace =
union {
sphere{0,1//,FaceSizeFloat
            scale <.025/FaceSize,.075/FaceSize,.3/FaceSize>
      rotate <0,-22.5,0>
      translate<-1.575,.15,-.7>
         texture {HairTexture}
         }
         
         sphere{0,1//,FaceSizeFloat
      scale <.025/FaceSize,.075/FaceSize,.3/FaceSize>
      rotate <0,-22.5,0>
      translate<-1.575,.15,-.7>
         texture {HairTexture}
         scale <1,1,-1>
         } 
    sphere{0,1//,FaceSizeFloat
      scale <.025/FaceSize,.075/FaceSize,.2/FaceSize>
      rotate <0,-22.5,0>
      translate<-1.6,.15,-.7>
         texture {HairTexture}
         }
         
         sphere{0,1//,FaceSizeFloat
      scale <.025/FaceSize,.075/FaceSize,.2/FaceSize>
      rotate <0,-22.5,0>
      translate<-1.6,.15,-.7>
         texture {HairTexture}
         scale <1,1,-1>
         }
object{FemaleHead}
object{FemaleHair}
rotate 90*y
translate .5*y
}

//union {FemaleFace}

//#declare OpSkincol = color rgb <0.9,0.65,0.43>

#declare OpSkin = texture {
  pigment { color rgb <0.9,0.65,0.43> }
  normal {
  bumps 1
  scale .1
  bump_size .06125
  }
  finish { diffuse 0.6 phong 0.15 phong_size 20 }
  } // end OpSkin


#declare OpEye = sphere {
  0,1
  texture {
    pigment { wood
      color_map {
        [0.25 color rgb 0]
        [0.25 color rgb <.375,.375,.75>]
        [0.45 color rgb <.375,.375,.75>]
        [0.45 color rgb 1]
        }
      scale 2.1
      }
    }
  }
  #declare HairTex =
  texture {
pigment {bozo color_map {
[0 rgb <1,.75,.25>*.5]
[1 rgb <1,.75,.25>*.25]
}
}
normal {bumps}
scale <.5,.5,.5>
}
texture {
pigment {bozo color_map {
[0 rgb <1,.75,.25>*.25 transmit 1]
[.5 rgb <1,.75,.25>*.25 transmit 1]
[1 rgb <1,.75,.25>*.125]
}
}
normal {waves}
scale <.06125,6,.06125>
}




  
  #declare OpFace = 0
  
  #declare MaleHead =
  union {
  union { // head
    blob {
      threshold 0.5
      cylinder {<0,-4.125,0>,<0,8,0>,8,1
      }   
        sphere { 0, 1, 1 // lower face
        scale <5,3,4>
        translate z*3
        texture {HairTex rotate 90*z}
        }
      sphere { 0, 1, 1 // lower face
        scale <3.5,3,4>
        translate <0,2,2.5>
        texture {HairTex rotate 90*z}
        
        }
      cylinder {<2.25,6,0.5>,<2.75,0.5,1.75>,2,.5 
      //pigment {rgb -1}
      texture {HairTex rotate 90*z}
      } // jaw r
      cylinder {<-2.25,6,0.5>,<-2.75,0.5,1.75>,2,.5 texture {HairTex rotate 90*z}
      } // jaw l 
            
      sphere { 0,1,.125  // brow r
        scale <2.5,1.5,3>
        rotate z*10
        #if (OpFace >0)
          rotate z*40*(OpFace-0.5)
          #end
        translate <1.75,8.25-(OpFace-0.5)/2,3>
        }
      sphere { 0,1,.125  // brow l
        scale <2.5,1.5,3>
        rotate z*-10
        #if (OpFace >0)
          rotate z*-40*(OpFace-0.5)
          #end
        translate <-1.75,8.25-(OpFace-0.5)/2,3>
        }
      sphere { 0,1,.25  // lid r
        scale <1.5,0.75,1>
        translate <1.75,7,3.25>
        }
      sphere { 0,1,.25  // lid l
        scale <1.5,0.75,1>
        translate <-1.75,7,3.25>
        }
      sphere { 0,1,-1.25  // eye r
        scale <1,0.375,1>
        translate <1.875,7.25,3.5>
        }
      sphere { 0,1,-1.25  // eye l
        scale <1,0.375,1>
        translate <-1.875,7.25,3.5>
        }
      
      sphere { 0,1,.125  // cheek r
        scale 2
        translate <2,6,2>
        }
      sphere { 0,1,.125  // cheek l
        scale 2
        translate <-2,6,2>
        }
    
      sphere { 0,1,.125/2 // nose
        scale <1.75,5,1.75>
        translate <0,5.5,5.5>
     
        }
      sphere { 0,1,.25 // nose
        scale <1.5,3.5,2.125>
        translate <0,5.25,5.375>
        }
      sphere { 0,1,-.125/2 // nose
        scale <2.5,.75,.75>
        translate <0,4,5.5>
        }  
      sphere { 0,1,.25 // nose
        scale <1,1,1>
        translate <.75,4.5,4.75>
        }
      sphere { 0,1,.25 // nose
        scale <1,1,1>
        translate <-.75,4.5,4.75>
        }
      
      sphere { 0,1,-.5 // nose
        scale <.5,2,.5>
        translate <.5,4,4.5>
        }
      sphere { 0,1,-.5 // nose
        scale <.5,2,.5>
        translate <-.5,4,4.5>
        }  
      
      sphere { 0,1,.5/4 // nose
        scale <1,1,1>*3.5
        translate <0,4.375,5.5>
        }      
      
      sphere {0,1,1  // right ear
        scale <1.5,3,.875>
        rotate y*45
        translate <5,6,-1>
        }
      sphere {0,1,1  // right ear
        scale <1.25,2.75,.5>
        rotate y*45
        translate <5,6,-1.25>
        }  
      sphere {0,1,.125  // right ear
        scale <.75.875,.375>
        rotate y*45
        translate <4.675,3.45,-.675>
        }        
      
      sphere {0,1,-.675 // right ear hole
        scale <.875,1,0.75>
        rotate y*45
        translate <5,6.875,-0.75>
      }
      sphere {0,1,-.675 // right ear hole
        scale <.875,1.5,0.75>
        rotate y*45
        translate <5,5.5,-0.75>
      }
      sphere {0,1,-.5 // right ear hole
        scale <.5,.5,1.5>
        rotate y*45
        translate <4.675,5.125,-0.675>
        pigment {rgb 0 }
      }
      sphere {0,1,.125 // right ear hole
        scale <.675,.675,.75>
        rotate y*45
        translate <4.675,5.125,-0.35>
      }
      
      sphere {0,1,-.375 // right ear hole
        scale <.675,2.5,0.75>
        rotate y*45
        translate <4.675,6,-0.5>
      }
                  
                  
                  
   
      sphere {0,1,1  // right ear
        scale <1.5,3,.875>
        rotate y*-45
        translate <-5,6,-1>
        }
      sphere {0,1,1  // right ear
        scale <1.25,2.75,.5>
        rotate y*-45
        translate <-5,6,-1.25>
        }  
      sphere {0,1,.125  // right ear
        scale <.75.875,.375>
        rotate y*-45
        translate <-4.675,3.45,-.675>
        }        
      
      sphere {0,1,-.675 // right ear hole
        scale <.875,1,0.75>
        rotate y*-45
        translate <-5,6.875,-0.75>
      }
      sphere {0,1,-.675 // right ear hole
        scale <.875,1.5,0.75>
        rotate y*-45
        translate <-5,5.5,-0.75>
      }
      sphere {0,1,-.5 // right ear hole
        scale <.5,.5,1.5>
        rotate y*-45
        translate <-4.675,5.125,-0.675>
        pigment {rgb 0 }
      }
      sphere {0,1,.125 // right ear hole
        scale <.675,.675,.75>
        rotate y*-45
        translate <-4.675,5.125,-0.35>
      }                 
      sphere {0,1,-.375 // right ear hole
        scale <.675,2.5,0.75>
        rotate y*-45
        translate <-4.675,6,-0.5>
      }           
      sphere { 0, 1, 1 // lower lip
        scale <2.5,1,2.5>
        rotate x*-10
        #if (OpFace >0)
          rotate x*-40*(OpFace-0.5)
          #end
        translate <0,1.5,4.5>
texture {
  pigment { rgb <0.9,0.55,0.3375>*.25}
  finish { diffuse 0.6 phong 0.15 phong_size 20 }
  }
  }
   sphere { 0, 1, 1 // lower lip
        scale <2,.375,2>
        rotate x*-10
        #if (OpFace >0)
          rotate x*-40*(OpFace-0.5)
          #end
        translate <0,2.25,4.5>
texture {
  pigment { rgb <0.9,0.55,0.3375>*.25 }
  finish { diffuse 0.6 phong 0.15 phong_size 20 }
  } 
  }
  texture { OpSkin }
} // end face blob

    object { OpEye  // r
      translate <2,7.25,3.125>
      }
    object { OpEye  // l
        translate <-2,7.25,3.125>
     }
    
    union {  // cigarette
      cylinder { <0,0,0>,<0,0,3>,0.156
        texture {
          pigment { gradient z
            pigment_map {
              [0.33 crackle  color_map {
                               [0.5 color rgb <0.8,0.5,0.2>]
                               [0.5 color rgb <1,0.7,0.4>]
                               } scale 0.02 ]
              [0.33 color rgb 1]
              }
            scale 3
            }
          }
        }
      sphere {<0,0,3>,0.156  // heater
        texture {
          pigment { color rgb <1,0.1,0>}
          finish { ambient 1 }
          }
        }
      sphere {0,1  // ash
        scale <0.16,0.16,0.250>
        translate <0,0,3>
        texture {
          pigment { gradient z
            color_map {
              [0 color rgb 0.7]
              [0.7 color rgb 0.1]
              [0.9 color rgbt 1]
              }
            scale 0.1
            turbulence 1.0
            }
          finish { diffuse 0.9 }
          }
        }
      scale <2,2,1.75>
      rotate <-45,-12,0>
      translate <-1.5,1.875,4.75>
      }
    union {  // cigarette 2
      cylinder { <0,0,0>,<0,0,3>,0.156
        texture {
          pigment { gradient z
            pigment_map {
              [0.33 crackle  color_map {
                               [0.5 color rgb <0.8,0.5,0.2>]
                               [0.5 color rgb <1,0.7,0.4>]
                               } scale 0.02 ]
              [0.33 color rgb 1]
              }
            scale 3
            }
          }
        }
      sphere {0,1  // ash
        scale <0.16,0.16,0.250>
        translate <0,0,3>
        texture {
          pigment { gradient z
            color_map {
              [0 color rgb 0.7]
              [0.7 color rgb 0.1]
              [0.9 color rgbt 1]
              }
            scale 0.1
            turbulence 1.0
            }
          finish { diffuse 0.9 }
          }
        }
      scale <2,2,1.75>
      rotate <-20,0,0>
      translate <4.5,8,-2.5>
      }  // end cig union

blob {
threshold 0.5

cylinder{<0,0,0>,<0,1,0>,1,1
scale<8.05,7.5,7.75>
translate<0,5,0> }

cylinder{<0,0,0>,<0,1,0>,1,-7.5
scale<9.9,1747.7,26.725>
rotate<0,0,-90>
translate<-100,20,-2> }
translate 1*y
texture {HairTex} 
}
translate -4.125*y
scale .3
rotate 0*y
}
union {Glasses rotate 90*y rotate <5,0,0> scale <.875,1,1> translate <0,1.5,-.5>}
}



union {MaleHead rotate 360*y*clock}
